$(document).ready(function(){
	ExecuteHash();
});

$( window ).on( 'hashchange', function( e ) {
	// $('.modal').modal('hide');
	ExecuteHash();
} );

function ExecuteHash() {
	var hash = window.location.hash.substring(1);
	if (hash=='home' || hash=='Home' || hash=='' || hash==undefined) {
		hash = 'dashboard';
	}
	var class_link = hash.replaceAll('/','-');
	$('#loading_indicator').css('display','flex');

	if (hash!='') {
		
		$("#rt_main_content").hide().load(base_url+hash, {limit: 25}, 
		    function (responseText, textStatus, req) {
		        if (textStatus == "error") {
		          $('#rt_main_content').hide().load(base_url+'custom_not_found').fadeIn('0');
		        }
		        $('#loading_indicator').css('display','none');
		}).fadeIn(500);
	}else{
		$("#rt_main_content").hide().load(base_url+'dashboard', {limit: 25}, 
		    function (responseText, textStatus, req) {
		        if (textStatus == "error") {
		          $('#rt_main_content').hide().load(base_url+'custom_not_found').fadeIn('0');
		        }
		        $('#loading_indicator').css('display','none');
		}).fadeIn(500);
	}
	
	setNav(hash.toLowerCase())
}

String.prototype.replaceAll = function (find, replace) {
    var str = this;
    return str.replace(new RegExp(find.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&'), 'g'), replace);
};

function setNav(currentPage)
{
	document.querySelectorAll(".nav-tw").forEach(el => {
	    el.classList.remove("bg-[#9ACBD0]");
	    el.classList.add("bg-white");

	    let svg = el.querySelector("svg");
	    if (svg) svg.setAttribute("fill", "#9ACBD0");

	    let span = el.querySelector("span");
	    if (span) span.style.display = "none";
	});

	let activeNav = document.getElementById(`nav_${currentPage}`);

	if (activeNav) {
	    activeNav.classList.remove("bg-white");
	    activeNav.classList.add("bg-[#9ACBD0]");

	    let activeSvg = activeNav.querySelector("svg");
	    if (activeSvg) activeSvg.setAttribute("fill", "#fff");

	    let activeSpan = activeNav.querySelector("span");
	    if (activeSpan) activeSpan.style.display = "block";
	}


}