<?php

    function getValueType($row){
        if(strtoupper($row->type) == "HOURS"){
            return $row->value . "h";
        } else {
            return strtoupper($row->type) == "CURRENT" ? $row->value . " Amp" : $row->value . " C";
        }
    }

    function getStandartType($row){
        if(strtoupper($row->type) == "HOURS"){
            return "";
        } else {
            return strtoupper($row->type) == "CURRENT" ? "< 9,3" : "< 130 C";
        }
    }

    if (strtoupper($type)=="EXCEL") {
        header("Content-type: application/vnd-ms-excel");
        header("Content-Disposition: attachment; filename=Reporting-Machine (" . $name . ") " . date('Ymd_His') . ".xls");
    }else{
        echo "<script>window.onload = function() { window.print(); }</script>";
    }

?>

<!DOCTYPE html>
<html>
<head>
    <title>Machine Reporting</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12pt;
        }

        table {
            border-collapse: collapse;
            margin-top: 10px;
        }

        th, td {
            border: 1px solid black;
            padding: 10px 12px;
            text-align: left;
        }

        th {
            background-color: #f2f2f2;
        }

        .center-text {
            text-align: center;
            font-weight: bold;
        }

        .vertical-text {
            writing-mode: vertical-rl;
            text-align: center;
            vertical-align: middle;
            transform: rotate(180deg);
        }
    </style>
</head>
<body>

    <h2 class="center-text" style="margin-top: 40px;">MACHINE DATA REPORT</h2>
    <p><strong>Date</strong> : <?= date('d-m-Y', strtotime($start)) ?> - <?= date('d-m-Y', strtotime($end)) ?></p>
    <p><strong>Lokasi</strong> : Machining Area</p>

    <h3 class="center-text" style="margin-top: 40px; margin-bottom: 20px;"><em>Preventive Maintenance Routine (PMR)</em></h3>

    <table style="width: 1000px; margin-bottom: 40px;">
        <colgroup>
            <col style="width: 5%;">
            <col style="width: 20%;">
            <col style="width: 35%;">
            <col style="width: 20%;">
            <col style="width: 20%;">
        </colgroup>
        <tr>
            <th class="center-text">No</th>
            <th class="center-text">Area</th>
            <th class="center-text">Task</th>
            <th class="center-text">Standart</th>
            <th class="center-text">Value</th>
        </tr>
        <tr>
            <td rowspan="4" class="center-text" style="vertical-align: middle;">1</td>
            <td rowspan="4" class="vertical-text"><?= $name ?></td>
            <td style="">Average RPM</td>
            <td style=""></td>
            <td><?= $rpm ?> RPM</td>
        </tr>
        <tr>
            <td style="">Average Current</td>
            <td style=""></td>
            <td><?= $current ?> Amp</td>
        </tr>
        <tr>
            <td>Motor Temperature</td>
            <td>&lt; 130 C</td>
            <td><?= $temperature ?> C</td>
        </tr>
        <tr>
            <td>Total Hours</td>
            <td>&lt; <?= $target ?> h</td>
            <td><?= $total ?> h</td>
        </tr>
    </table>

    <table style="width: 1000px; margin-top: 100px;">
        <colgroup>
            <col style="width: 60%;">
            <col style="width: 20%;">
            <col style="width: 10%;">
            <col style="width: 10%;">
        </colgroup>
        <tr>
            <th>Message</th>
            <th style="text-align: center;">Standart</th>
            <th style="text-align: center;">Value</th>
            <th style="text-align: center;">Waktu</th>
        </tr>
        <?php if (!empty((array) $alerts)): ?>
            <?php foreach ($alerts as $alert): ?>
                <tr>
                    <td><?= $alert->message ?></td>
                    <td style="text-align: center;"><?= getStandartType($alert) ?></td>
                    <td style="text-align: center;"><?= getValueType($alert) ?></td>
                    <td style="text-align: center;"><?= date('H:i d-m-Y', strtotime($alert->created_at)) ?></td>
                </tr>
            <?php endforeach; ?>
        <?php endif; ?>
    </table>

</body>
</html>
